const crypto = require("crypto");
const mongoose = require("mongoose");
const validator = require("validator");
const bcrypt = require("bcryptjs");

const userSchema = new mongoose.Schema({
  emailAddress: {
    type: String,
    required: [true, "Email Address is required."],
    lowercase: true,
    validate: [validator.isEmail, "Please enter a valid email"],
  },
  firstName: {
    type: String,
  },
  lastName: {
    type: String,
  },
  profilePicture: {
    type: String,
  },
  password: {
    type: String,
    require: [true, "Please provide a password."],
    // minLength: 8,
    // select: false,
  },
  passwordConfirm: {
    type: String,
    // require: [true, "Please provide a password."],
    // validate: {
    //   validator: function (el) {
    //     return el === this.password; //Only works on SAVE! or Create!
    //   },
    //   message: "Password Should match",
    // },
    select: false,
  },
  userGroupId: {
    type: String,
  },
  country: {
    type: String,
  },
  contact: {
    type: String,
  },
  currency: {
    type: String,
    default: "USD",
  },
  exchangeRate: {
    type: Number,
    default: 1,
  },
  userGroup: {
    type: String,
    default: "mobileApp",
  },
  IsActive: {
    type: Boolean,
  },
  IsDelete: {
    type: Boolean,
  },
  CreatedBy: {
    type: String,
  },
  CreatedOn: {
    type: Date,
  },
  ModifiedBy: {
    type: String,
    default: null,
  },
  ModifiedOn: {
    type: Date,
    default: null,
  },
  passwordChangedAt: {
    type: Date,
  },
  passwordResetToken: {
    type: String,
  },
  passwordResetExpires: {
    type: Date,
  },
});

userSchema.pre("save", async function (next) {
  if (!this.isModified("password")) return next();

  // this.password = await bcrypt.hash(this.password, 12);
  this.password = this.password;
  this.passwordConfirm = undefined;
  next();
});

userSchema.pre("save", function (next) {
  if (!this.isModified("password") || this.isNew) return next();

  this.passwordChangedAt = Date.now() - 1000;
  next();
});

userSchema.methods.correctPassword = async function (
  candidatePassword,
  userPassword
) {
  return candidatePassword === userPassword;
  // return await bcrypt.compare(candidatePassword, userPassword);
};

userSchema.methods.changePasswordAfter = function (JWTTimeStamp) {
  if (this.passwordChangedAt) {
    const changedTimeStamp = this.passwordChangedAt.getTime() / 1000;
    return JWTTimeStamp < changedTimeStamp;
  }
  //false means not changed
  return false;
};

userSchema.methods.createPasswordResetToken = function () {
  const resetToken = crypto.randomBytes(32).toString("hex");

  this.passwordResetToken = crypto
    .createHash("sha256")
    .update(resetToken)
    .digest("hex");

  this.passwordResetExpires = Date.now() + 10 * 60 * 1000;
  return resetToken;
};

const User = mongoose.model("User", userSchema);

module.exports = User;
