const express = require("express");
const ProductsController = require("../controllers/productsController");

const router = express.Router();

router.get("/api/Get_Products", ProductsController.getProducts);
router.get("/api/Get_ProductById=:id", ProductsController.getProductsById);
router.get(
  "/api/Get_Products_Dropdown",
  ProductsController.getProductsDropdown
);
router.post("/api/Save_Product", ProductsController.saveProduct);
router.post("/api/Edit_Product", ProductsController.editProduct);
router.post("/api/Delete_Product", ProductsController.deleteProduct);

module.exports = router;
